<?php

namespace UtillzCore\Inc\Src\Form\Modules\Use_Field;

use \UtillzCore\Inc\Src\Form\Modules\Module;

class Use_Field extends Module {
private $groups = [];
    public function before_construct() {

        $this->defaults += [
            'options' => [],
            'group' => 'text',
            'allow_empty' => true,
            'exclude' => [],
            'include' => [],
        ];

        // specify group of field types to search for
        $this->groups = [
            'any' => [
                // all type of fields
            ],
            'text' => [
                'text',
                'textarea',
                'editor',
                'faq',
                'number',
            ],
            'checkbox' => [
                'checkbox',
                'toggle',
            ],
            'number' => [
                'number',
            ],
            'taxonomy' => [
                'taxonomy',
            ],
            'media' => [
                'upload',
            ],
        ];

    }

    public function after_build() {

        // get all terms
        if( get_post_type() !== 'ulz_listing_type' ) {

            $taxonomies = [
                'ulz_listing_category' => esc_html__('Category', 'utillz-core'),
                'ulz_listing_region' => esc_html__('Region', 'utillz-core'),
                'ulz_listing_tag' => esc_html__('Tags', 'utillz-core'),
            ];

            $custom_taxonomies = Ucore()->get_custom_taxonomies();
            if( is_array( $custom_taxonomies ) ) {
                foreach( $custom_taxonomies as $custom_taxonomy ) {
                    $taxonomies[ $custom_taxonomy->slug ] = $custom_taxonomy->name;
                }
            }

            $this->props->options = $taxonomies;

        }
        // collect listing type terms from fields
        else{

            foreach( Ucore()->jsoning( 'ulz_fields' ) as $k => $item ) {

                if( $this->props->group !== 'any' ) {
                    if( ! in_array( $item->template->id, $this->groups[ $this->props->group ] ) ) {
                        continue;
                    }
                }

                if( isset( $item->fields->key ) ) {
                    $this->props->options += [ Ucore()->prefix( $item->fields->key ) => $item->fields->name ];
                }

            }

        }

        // exclude
        if( $this->props->exclude ) {
            foreach( $this->props->exclude as $exclude ) {
                unset( $this->props->options[ $exclude ] );
            }
        }

        // include
        if( $this->props->include ) {
            $this->props->options = array_merge( $this->props->options, $this->props->include );
        }

    }

    public function get() {

        return $this->template();

    }

    public function controller() {

        return [
            'props' => (array) $this->props,
            'component' => $this->component,
        ];

    }

}